import 'package:flutter/material.dart';
import 'package:easy_localization/easy_localization.dart';
import 'package:feather_icons/feather_icons.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:wordpress_app/blocs/user_bloc.dart';
import 'package:wordpress_app/pages/delete_social_user.dart';
import 'package:wordpress_app/pages/delete_user.dart';


class SecurityPage extends ConsumerStatefulWidget {
  const SecurityPage({super.key});

  @override
  ConsumerState<SecurityPage> createState() => _SecurityPageState();
}

class _SecurityPageState extends ConsumerState<SecurityPage> {

  
  void _openDeletePopup (){
    final UserBloc ub = ref.read(userBlocProvider);
    showModalBottomSheet(
      isDismissible: true,
      enableDrag: true,
      isScrollControlled: true,
      backgroundColor: Theme.of(context).canvasColor,
      clipBehavior: Clip.antiAliasWithSaveLayer,
      shape: const RoundedRectangleBorder(borderRadius: BorderRadius.only(topLeft: Radius.circular(20), topRight: Radius.circular(20))),
      context: context, builder: (context){
        if(ub.signInProvider == 'email'){
          return const DeleteUser();
        }else{
          return const DeleteSocialUser();
        }
      });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('security').tr(),
      ),
      body: Stack(
        alignment: Alignment.center,
        children: [
          Column(
            children: [
              ListTile(
                contentPadding: const EdgeInsets.all(15),
                isThreeLine: false,
                title: const Text(
                  'account-delete',
                  style: TextStyle(
                    fontWeight: FontWeight.w500,
                  ),
                ).tr(),
                leading: CircleAvatar(
                  backgroundColor: Theme.of(context).colorScheme.errorContainer,
                  radius: 20,
                  child: Icon(
                    FeatherIcons.trash,
                    size: 20,
                    color: Theme.of(context).colorScheme.onErrorContainer,
                  ),
                ),
                onTap: ()=> _openDeletePopup()
              ),
            ],
          ),
        ],
      ),
    );
  }
}




